@extends('include.app')


@section('content')


<div class="text-right mb-3">
    <a class="btn btn-primary" href="" data-toggle="modal" data-target="#addunitmodel"  onclick="myFunction()">Add Unit
    </a>
</div>

<div class="modal fade" id="addunitmodel" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
aria-hidden="true" >
    <div class="modal-dialog " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class=" ">
                    <h5>Create Unit</h5>
                </div>
                {{-- <h5 class="modal-title" id="exampleModalLongTitle"></h5> --}}
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

             
                  
                    <div class="">
                        <form action="" method="post" enctype="multipart/form-data" class="addunit" id="addForm" autocomplete="off">
                            @csrf
                            <div class="form-group">
                                <label>Title</label>
                                <input type="text"  name="title" class="form-control" required>
                            </div>
                       

                            <div class="form-group text-right">
                                <input class="btn btn-success mr-1" type="submit" id="addcat2" value="Save">
                                <a href="#" class="btn btn-light text-dark" data-dismiss="modal" aria-label="Close">Close</a>
                            </div>

                        </form>


                    </div>

               

            </div>

        </div>
    </div>
</div>


<div class="card">
    <div class="card-header">
        <h4>Units</h4>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped" style="width: 100% !important;" id="unitshowtable">
                <thead>
                    <tr>
                       
                        <th style="width: 80%;" >Title</th>
                      
                        <th >Edit</th>
                        {{-- <th >Delete</th> --}}
                    </tr>
                </thead>
                <tbody >

                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="edit_unit_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit Unit</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="" method="post" enctype="multipart/form-data"  id="edit_cat" autocomplete="off">

                    @csrf
                    <input type="hidden" class="form-control" id="editunitid" name="id" value="">
       
                    <div class="form-group">
                        <label for="">Title</label>
                        <input type="text" class="form-control" id="edit_title" name="title"  required>
                    </div>

                

                    <div class="form-group text-right">
                        <input type="submit" class=" btn btn-success" id="editcat2">
                        <a href="#" class="btn btn-light text-dark" data-dismiss="modal" aria-label="Close">Close</a>
                    </div>

                </form>
            </div>

        </div>
    </div>
</div>



<script>

function myFunction() {

$('#addForm')[0].reset();


}


var user_type = {{session('user_type')}};
    $(document).ready(function () {
        

        $(".sideBarli").removeClass("activeLi");
        $(".unitsSideA").addClass("activeLi");
                    $('#unitshowtable').dataTable({
                            'processing': true,
                            'serverSide': true,
                            'serverMethod': 'post',
                            "aaSorting": [[ 0, "desc" ]],
                            'columnDefs': [{
                                'targets': [1], // column index (start from 0)
                                'orderable': false, 
                        
                                /* column index */
                                // 'orderable': false,
                                /* true or false */
                            }],
                            'ajax': {
                                'url': '{{ route('fetchAllUnits') }}',
                                'data': function(data) {
                        
                                }
                            }
                        });


                        $("#addForm").submit(function(event) {
                    event.preventDefault();
                    $('.loader').show();
                

                    if (user_type == "1") {

                        var formdata = new FormData($("#addForm")[0]);
                        console.log(formdata);


                        $.ajax({
                            url: '{{ route('addUnit')}}',
                            type: 'POST',
                            data: formdata,
                            dataType: "json",
                            contentType: false,
                            cache: false,
                            processData: false,
                            success: function(response) {
                                console.log(response);

                                if(response.status == true){
                                $('#unitshowtable').DataTable().ajax.reload(null, false);
                                $('.loader').hide();
                                $('#addunitmodel').modal('hide');
                                    $('#addForm')[0].reset(); 

                                }
                                else{
                                    $('.loader').hide();
                                    iziToast.error({
                                    title: 'Error!',
                                    message: 'Unit Already Exists',
                                    position: 'topRight'
                                    });
                                }

                            },
                            error: function(err) {
                                $('.loader').hide();
                            
                                            console.log(JSON.stringify(err));
                                        

                            }

                        });
                    } else {

                        $('.loader').hide();
                        iziToast.error({
                            title: 'Error!',
                            message: '  you are a tester ',
                            position: 'topRight'
                        });
                    }

                });

                $("#unitshowtable").on("click",".edit_units",function(event) {
                        $('#edit_cat')[0].reset();

                        $('#edit_title').val($(this).data('id'));
                        $('#editunitid').val($(this).attr('id'));
                    
                          $('#edit_unit_modal').modal('show');
              });


              $("#edit_cat").submit(function(event) {
        event.preventDefault();
        $('.loader').show();


        if (user_type == "1") {
            

            var formdata = new FormData($("#edit_cat")[0]);
            console.log(formdata);


            $.ajax({
                url: '{{ route('updateUnit')}}',
                type: 'POST',
                data: formdata,
                dataType: "json",
                contentType: false,
                cache: false,
                processData: false,
                success: function(response) {
                console.log(response);

                if(response.status == true){
                $('#unitshowtable').DataTable().ajax.reload(null, false);
                 $('#edit_cat')[0].reset(); 
                $('.loader').hide();
                $('#edit_unit_modal').modal('hide');

                 }
                else{
                    $('.loader').hide();
                    iziToast.error({
                      title: 'Error!',
                      message: 'Unit already exists.',
                      position: 'topRight'
                     });
                }

                },
                error: function(err) {

                    $('.loader').hide();
                
                            console.log(JSON.stringify(err));
                        

                }

            });


        } else {
            $('.loader').hide();
            iziToast.error({
                title: 'Error!',
                message: '  you are a tester ',
                position: 'topRight'
            });
        }
    });

    $("#unitshowtable").on("click",".delete-unit",function(event) {

event.preventDefault();



swal({
        title: "Are you sure?",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
    .then((willDelete) => {
        if (willDelete) {
            swal("Your unit has been deleted.", {
                icon: "success",
            });

            if (user_type == "1") {
                var element = $(this).parent();

                var id = $(this).attr("rel");
                var delete_cat_url = "{{route('deleteUnit', '')}}"+"/"+id;
    
                $.getJSON(delete_cat_url).done(function(data) {
                    console.log(data);
                });

                $('#unitshowtable').DataTable().ajax.reload(null, false);
              
            } else {
                iziToast.error({
                    title: 'Error!',
                    message: '  you are a tester  ',
                    position: 'topRight'
                });
            }

        } else {
            swal("Your unit is safe.");
        }
    });


});


});



</script>
@endsection