@extends('include.app')


@section('nav')
<li class="menu-header text-white">Main</li>
<li class="  ">
    <a href="{{ route('index') }}" class="nav-link text-white "><i
            class="fas fa-tachometer-alt pt-1"></i><span>Dashboard</span></a>
</li>

<li class=" ">
    <a href="{{ route('users') }}" class="nav-link"><i
            class="fas fa-users"></i></i><span>Users</span></a>
</li>

<li class="menu-header text-white">Product</li>



<li class="">
    <a href="{{ route('categories') }}" class="nav-link "><i
            class="fab fa-cuttlefish"></i><span>Category</span></a>
</li>

<li class="">
    <a href="{{ route('units') }}" class="nav-link "><i
            class="fab fa-uniregistry"></i><span>Unit</span></a>
</li>


<li class="activeLi">
    <a href="{{ route('product') }}" class="nav-link "><i
            class="fas fa-shopping-cart"></i><span>Product</span></a>
</li>





<li class="dropdown">
    <a href="{{ route('coupons') }}"><i class="fas fa-gift"></i><span>Coupan</span></a>
</li>
<li class="menu-header text-white">ORDERS</li>

<li class="dropdown">
    <a href="{{ route('orders') }}"><i class="fab fa-jedi-order"></i><span>Orders </span></a>
</li>
<li class="dropdown">
    <a href="{{ route('deliveryBoy') }}"><i class="fas fa-child"></i><span>Delivery Boy
        </span></a>
</li>
<li class="dropdown">
    <a href="{{ route('complaints') }}"><i class="fas fa-comment-alt"></i><span>Complaint
        </span></a>
</li>

<li class="dropdown">
    <a href="{{ route('reviews') }}"><i class="fas fa-star"></i><span>Review And Rating
        </span></a>
</li>
<li class="menu-header text-white">Setting</li>

<li class="">
    <a href="{{ route('banners') }}" class="nav-link "><i
            class="fas fa-image"></i><span>Banner</span></a>
</li>

<li class="">
    <a href="{{ route('faqs') }}" class="nav-link "><i
            class="fas fa-question-circle"></i><span>FAQ</span></a>
</li>

<li class="">
    <a href="{{ route('address') }}" class="nav-link "><i
            class="fas fa-map"></i><span>Address</span></a>
</li>

<li class="">
    <a href="{{ route('notification') }}" class="nav-link "><i
            class="fas fa-bell"></i><span>NotifiCation</span></a>
</li>

<li class="">
    <a href="{{ route('setting') }}" class="nav-link "><i class="fas fa-cog"></i><span>Other
            Setting</span></a>
</li>


@endsection
@section('content')

    <style>
        .nav-pills .active {
            background-image: linear-gradient(#E66138, #FC3901 ) !important;

        }

        .nav-pills .nav-link {
            color: black !important;
        }

        .total_open_complaint{
            background-color: #FFDA4B !important;
            
            padding: 5px 10px 2px 10px !important;
            margin-bottom: 2px !important;
        }

    </style>

    
<?php 

use Illuminate\Support\Facades\DB;

$allproduct = DB::table('product')->count();
$ofsproduct = DB::table('product')->where('stock',0)->count();


?>


    <div class="text-right mb-3">

        <a href="{{ route('addProduct') }}" class="btn btn-primary">Add Product </a>
    </div>


    <div class="card mt-3">

        <div class="card-header">
            <h4>Products  ( {{$allproduct}} )</h4>
        </div>

        <div class="card-body">


            <div class="tab  " role="tabpanel">
                <ul class="nav nav-pills border-b mb-3  ml-0">

                    <li role="presentation" class="nav-item bg-light "><a class="nav-link pointer active" href="#Section1"
                            aria-controls="home" role="tab" data-toggle="tab">All Products <span
                                class="badge badge-transparent total_open_complaint"></span></a>
                    </li>

                    <li role="presentation" class="nav-item bg-light "><a class="nav-link pointer" href="#Section3" role="tab"
                            data-toggle="tab">Out Of Stock Products<span
                                class="badge badge-transparent total_open_complaint"></span></a>
                    </li>
                </ul>

                <hr>

                <div class="tab-content tabs" id="home">

                    <div role="tabpanel" class="tab-pane active" id="Section1">

                        <div class="table-responsive">
                            <table class="table table-striped" id="allProductTable" style="width: 100% !important;">
                                <thead>
                                    <tr>
                                        <th>Image</th>
                                        <th>Name</th>
                                        <th>Unit Price</th>
                                        <th>In Stock </th>
                                        <th width='150'>Category </th>
                                        <th >Action </th>
                                    </tr>
                                </thead>
                                <tbody id="">

                                </tbody>
                            </table>
                        </div>
                    </div>


                    <div role="tabpanel" class="tab-pane " id="Section3">
                        <div class="table-responsive">
                            <table class="table table-striped" id="outofstocktable" style="width: 100% !important;">
                                <thead>
                                    <tr>
                                        <th>Image</th>
                                        <th>Name</th>
                                        <th>Unit Price</th>
                                        <th>In Stock </th>
                                        <th width='150'>Category </th>
                                        <th width='150'>Action </th>
                                    </tr>
                                </thead>
                                <tbody id="">

                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <script>
        var user_type = {{ session('user_type') }};

        $(document).ready(function() {


            $(".sideBarli").removeClass("activeLi");
        $(".productSideA").addClass("activeLi");


            $('#allProductTable').dataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                "aaSorting": [
                    [0, "desc"]
                ],
                'columnDefs': [{
                    'targets': [0,3,4,5],
                    /* column index */
                    'orderable': false,
                    /* true or false */
                }],
                'ajax': {
                    'url': '{{ route('fetchAllProduct') }}',
                    'data':  {
                        // console.log(data);
                        //$('#table-1').dataTable().draw();

                        // Read values
                        // var user_id = $('#user_id').val();

                        // Append to data
                        // data.user_id = user_id;
                    },
                    error: function(err) {


                        console.log(JSON.stringify(err));


                    }

                }
            });


            $('#outofstocktable').dataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                "aaSorting": [
                    [0, "desc"]
                ],
                'columnDefs': [{
                    'targets': [0, 1],
                    /* column index */
                    'orderable': false,
                    /* true or false */
                }],
                'ajax': {
                    'url': '{{ route('fetchAllOfsProduct') }}',
                    'data': function(data) {
                        // console.log(data);
                        //$('#table-1').dataTable().draw();

                        // Read values
                        // var user_id = $('#user_id').val();

                        // Append to data
                        // data.user_id = user_id;
                    },
                    error: function(err) {


                        console.log(JSON.stringify(err));


                    }

                }
            });


            $('#allProductTable').on("change", ".stock", function(event) {

                event.preventDefault();
       

                swal({
                        title: "Are you sure?",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            swal("Your Product Add Out of Stock", {
                                icon: "success",
                            });

                            if (user_type == "1") {



                $id = $(this).attr("rel");

                if ($(this).prop("checked") == true) {
                    swal("Your Product Add In Stock", {
                                icon: "success",
                            });
                    $value = 1;
                } else {

                    swal("Your Product Add Out Stock", {
                                icon: "success",
                            });
                    console.log("Checkbox is unchecked.");
                    $value = 0;
                }
                $.post('{{ route('updateStock') }}', {
                        id: $id,
                        stock: $value
                    },
                    function(returnedData) {
                        console.log(returnedData);
                        $('#allProductTable').DataTable().ajax.reload(null, false);
                        $('#outofstocktable').DataTable().ajax.reload(null, false);
                    }).fail(function() {
                    console.log("error");
                });

                    } else {
                                iziToast.error({
                                    title: 'Error!',
                                    message: ' you are Tester ',
                                    position: 'topRight'
                                });
                            }

                        } else {
                            $('#allProductTable').DataTable().ajax.reload(null, false);
                            $('#outofstocktable').DataTable().ajax.reload(null, false);
                            swal("Your Product Not Add Out of Stock");
                        }
                    });


            });


            $('#outofstocktable').on("change", ".stock", function(event) {

                event.preventDefault();


                swal({
                        title: "Are you sure?",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            swal("Your Product Add In  Stock", {
                                icon: "success",
                            });

                            if (user_type == "1") {



                $id = $(this).attr("rel");

                if ($(this).prop("checked") == true) {
                    $value = 1;
                } else {
                    console.log("Checkbox is unchecked.");
                    $value = 0;
                    
                }
                $.post('{{ route('updateStock') }}', {
                        id: $id,
                        stock: $value
                    },
                    function(returnedData) {
                        console.log(returnedData);
                        $('#allProductTable').DataTable().ajax.reload(null, false);
                        $('#outofstocktable').DataTable().ajax.reload(null, false);
                    }).fail(function() {
                    console.log("error");
                });

                    } else {
                                iziToast.error({
                                    title: 'Error!',
                                    message: ' you are Tester ',
                                    position: 'topRight'
                                });
                            }

                        } else {
                            $('#allProductTable').DataTable().ajax.reload(null, false);
                            $('#outofstocktable').DataTable().ajax.reload(null, false);
                            swal("Your Product Add In Stock");
                        }
                    });


                });

                $("#allProductTable").on("click", ".deleteproduct", function(event) {

                event.preventDefault();



                swal({
                        title: "Are you sure?",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            swal("Your Product has Deleted", {
                                icon: "success",
                            });

                            if (user_type == "1") {
                                var element = $(this).parent();

                                var id = $(this).attr("rel");
                                var delete_cat_url = "{{ route('deleteProduct', '') }}" + "/" + id;

                                $.getJSON(delete_cat_url).done(function(data) {
                                    console.log(data);
                                });

                                $('#allProductTable').DataTable().ajax.reload(null, false);
                                $('#outofstocktable').DataTable().ajax.reload(null, false);

                            } else {
                                iziToast.error({
                                    title: 'Error!',
                                    message: ' you are Tester ',
                                    position: 'topRight'
                                });
                            }

                        } else {
                            swal("Your Product safe");
                        }
                    });


            });

            $("#outofstocktable").on("click", ".deleteproduct", function(event) {

                event.preventDefault();



                swal({
                        title: "Are you sure?",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            swal("Your Product has Deleted", {
                                icon: "success",
                            });

                            if (user_type == "1") {
                                var element = $(this).parent();

                                var id = $(this).attr("rel");
                                var delete_cat_url = "{{ route('deleteProduct', '') }}" + "/" + id;

                                $.getJSON(delete_cat_url).done(function(data) {
                                    console.log(data);
                                });

                                $('#allProductTable').DataTable().ajax.reload(null, false);
                                $('#outofstocktable').DataTable().ajax.reload(null, false);

                            } else {
                                iziToast.error({
                                    title: 'Error!',
                                    message: ' you are Tester ',
                                    position: 'topRight'
                                });
                            }

                        } else {
                            swal("Your Product safe");
                        }
                    });


            });
        });

    </script>

@endsection
