@extends('include.app')

@section('nav')
<li class="menu-header text-white">Main</li>
<li class="  ">
    <a href="{{ route('index') }}" class="nav-link text-white "><i
            class="fas fa-tachometer-alt pt-1"></i><span>Dashboard</span></a>
</li>

<li class=" ">
    <a href="{{ route('users') }}" class="nav-link"><i
            class="fas fa-users"></i></i><span>Users</span></a>
</li>

<li class="menu-header text-white">Product</li>



<li class="">
    <a href="{{ route('categories') }}" class="nav-link "><i
            class="fab fa-cuttlefish"></i><span>Category</span></a>
</li>

<li class="">
    <a href="{{ route('units') }}" class="nav-link "><i
            class="fab fa-uniregistry"></i><span>Unit</span></a>
</li>


<li class="">
    <a href="{{ route('product') }}" class="nav-link "><i
            class="fas fa-shopping-cart"></i><span>Product</span></a>
</li>





<li class="dropdown">
    <a href="{{ route('coupons') }}"><i class="fas fa-gift"></i><span>Coupan</span></a>
</li>
<li class="menu-header text-white">ORDERS</li>

<li class="dropdown">
    <a href="{{ route('orders') }}"><i class="fab fa-jedi-order"></i><span>Orders </span></a>
</li>
<li class="dropdown">
    <a href="{{ route('deliveryBoy') }}"><i class="fas fa-child"></i><span>Delivery Boy
        </span></a>
</li>
<li class="dropdown">
    <a href="{{ route('complaints') }}"><i class="fas fa-comment-alt"></i><span>Complaint
        </span></a>
</li>

<li class="activeLi">
    <a href="{{ route('reviews') }}"><i class="fas fa-star"></i><span>Review And Rating
        </span></a>
</li>
<li class="menu-header text-white">Setting</li>

<li class="">
    <a href="{{ route('banners') }}" class="nav-link "><i
            class="fas fa-image"></i><span>Banner</span></a>
</li>

<li class="">
    <a href="{{ route('faqs') }}" class="nav-link "><i
            class="fas fa-question-circle"></i><span>FAQ</span></a>
</li>

<li class="">
    <a href="{{ route('address') }}" class="nav-link "><i
            class="fas fa-map"></i><span>Address</span></a>
</li>

<li class="">
    <a href="{{ route('notification') }}" class="nav-link "><i
            class="fas fa-bell"></i><span>NotifiCation</span></a>
</li>

<li class="">
    <a href="{{ route('setting') }}" class="nav-link "><i class="fas fa-cog"></i><span>Other
            Setting</span></a>
</li>


@endsection
@section('content')



    <div class="card">
        <div class="card-header">
            <h4>Reviews </h4>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped" style="width: 100% !important;" id="reviewTable">
                    <thead>
                        <tr>
                            <th>Order Id </th>
                            <th>User Name</th>
                            <th>Reviews</th>
                            <th>Ratings</th>
                            <th>Featured</th>
                            <th>Action</th>

                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {

                
      $(".sideBarli").removeClass("activeLi");
            $(".reviewsSideA").addClass("activeLi");
            $('#reviewTable').dataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                "aaSorting": [
                    [0, "desc"]
                ],
                'columnDefs': [{
                    'targets': [1, 2], // column index (start from 0)
                    'orderable': false,

                    /* column index */
                    // 'orderable': false,
                    /* true or false */
                }],
                'ajax': {
                    'url': '{{ route('fetchAllReview') }}',
                    'data': function(data) {

                    }
                }
            });

            $("#reviewTable").on("click", ".deleteitem", function(event) {

                event.preventDefault();



                swal({
                        title: "Are you sure?",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            swal("Your review has been delete", {
                                icon: "success",
                            });

                            if (user_type == "1") {
                                var element = $(this).parent();

                                var id = $(this).attr("rel");
                                var delete_cat_url = "{{ route('deleteReview', '') }}" + "/" + id;

                                $.getJSON(delete_cat_url).done(function(data) {
                                    console.log(data);
                                });

                                $('#reviewTable').DataTable().ajax.reload(null, false);

                            } else {
                                iziToast.error({
                                    title: 'Error!',
                                    message: '  you are a tester ',
                                    position: 'topRight'
                                });
                            }

                        } else {
                            swal("Your review is safe");
                        }
                    });


            });

            $('#reviewTable').on("change", ".feacherd", function(event) {

event.preventDefault();


swal({
        title: "Are you sure?",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
    .then((willDelete) => {
        if (willDelete) {
            swal("Review added successfully.", {
                icon: "success",
            });

            if (user_type == "1") {



$id = $(this).attr("rel");

if ($(this).prop("checked") == true) {
    swal("Your review is feaacherd", {
                icon: "success",
            });
    $value = 1;
} else {

    swal("Your review Add in feartued ", {
                icon: "success",
            });
    // console.log("Checkbox is unchecked.");
    $value = 0;
}
$.post('{{ route('updateReview') }}', {
        id: $id,
        feacherd: $value
    },
    function(returnedData) {
        console.log(returnedData);
        $('#reviewTable').DataTable().ajax.reload(null, false);
       
    }).fail(function() {
    console.log("error");
});

    } else {
                iziToast.error({
                    title: 'Error!',
                    message: ' you are Tester ',
                    position: 'topRight'
                });
            }

        } else {
            $('#reviewTable').DataTable().ajax.reload(null, false);
            
            swal("Your review Not Add in feratured");
        }
    });


});


        });

    </script>
@endsection
