@extends('include.app')


@section('content')

    <style>
        .nav-pills .active {
            background-image: linear-gradient(#E66138, #FC3901 ) !important;

        }

        .nav-pills .nav-link {
            color: black !important;
        }

     

    </style>


    <div class="modal fade" id="deliveryBoyModal" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
        aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Delivery Boy </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <form action="" method="POST" id="deliveryfrom">
                    <div class="modal-body">

                        <input type="hidden" name="id" class="id">
                        <div class="form-group ">
                            <label>&nbsp;</label>
                            <select class="form-control select_delivery" name="deliveryBoy_id" required>

                                <option disabled selected value="">Select</option>

                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="form-group text-right">
                            <input type="submit" class=" btn btn-success" value="Confirm">
                            <a href="#" class="btn btn-light text-dark" data-dismiss="modal" aria-label="Close">Close</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        $(document).on("click", ".confirmOrder", function(event) {


            $('.id').val($(this).attr('rel'));



            $.getJSON("{{ route('getDelivryBoy') }}").done(function(data) {

                $('.select_delivery option').remove();
                $('.select_delivery').html('<option disabled selected value="">Select</option>');

                $.each(data.boys, function(index, item) {
                    var element;
                    var parent = $('.select_delivery');



                    element = `
                                <option value="${item.id}">${item.username}</option>`;

                    parent.append(element);


                });

            });

           



        });

        $("#deliveryfrom").submit(function(event) {
                event.preventDefault();
                $('.loader').show();


                if (user_type == "1") {

                    var formdata = new FormData($("#deliveryfrom")[0]);
                    console.log(formdata);


                    $.ajax({
                        url: '{{ route('confirmOrder') }}',
                        type: 'POST',
                        data: formdata,
                        dataType: "json",
                        contentType: false,
                        cache: false,
                        processData: false,
                        success: function(response) {
                            console.log(response);

                            if (response.status == true) {
                                $('#allOrderTable').DataTable().ajax.reload(null, false);
                                $('#CancelledTable').DataTable().ajax.reload(null, false);
                                $('#CompletedTable').DataTable().ajax.reload(null, false);
                                $('#holdTable').DataTable().ajax.reload(null, false);
                                $('#ConfirmedTable').DataTable().ajax.reload(null, false);
                                $('#ProcessingTable').DataTable().ajax.reload(null, false);
                                $('.loader').hide();
                                $('#deliveryBoyModal').modal('hide');
                                //     $('#addForm')[0].reset(); 
                                iziToast.success({
                                    title: 'success!',
                                    message: 'Confirm Order Successfull',
                                    position: 'topRight'
                                });
                                // $('#cat_title').val('');
                                // $('.add_image5').val('');
                            }


                        },
                        error: function(err) {
                            $('.loader').hide();

                            console.log(JSON.stringify(err));


                        }

                    });
                } else {

                    $('.loader').hide();
                    iziToast.error({
                        title: 'Error!',
                        message: ' you are Tester ',
                        position: 'topRight'
                    });
                }

            });
    </script>


    <div class="card mt-3">

        <div class="card-header">
            <h4>Order List</h4>
        </div>

        <div class="card-body">


            <div class="tab  " role="tabpanel">
                <ul class="nav nav-pills border-b mb-3  ml-0">

                    <li role="presentation" class="nav-item bg-light "><a class="nav-link pointer active" href="#Section1"
                            aria-controls="home" role="tab" data-toggle="tab">All Orders <span
                                class="badge badge-transparent total_open_complaint"></span></a>
                    </li>

                    <li role="presentation" class="nav-item bg-light ml-2 "><a class="nav-link pointer" href="#Section2"
                            role="tab" data-toggle="tab">Processing Orders<span
                                class="badge badge-transparent total_open_complaint"></span></a>
                    </li>


                    <li role="presentation" class="nav-item bg-light ml-2"><a class="nav-link pointer" href="#Section3"
                            role="tab" data-toggle="tab">Confirmed Orders<span
                                class="badge badge-transparent total_open_complaint"></span></a>
                    </li>


                    <li role="presentation" class="nav-item bg-light ml-2"><a class="nav-link pointer" href="#Section4"
                            role="tab" data-toggle="tab">On Hold Orders<span
                                class="badge badge-transparent total_open_complaint"></span></a>
                    </li>

                    <li role="presentation" class="nav-item bg-light ml-2"><a class="nav-link pointer" href="#Section5"
                            role="tab" data-toggle="tab">Completed Orders<span
                                class="badge badge-transparent total_open_complaint"></span></a>
                    </li>


                    <li role="presentation" class="nav-item bg-light ml-2"><a class="nav-link pointer" href="#Section6"
                            role="tab" data-toggle="tab">Cancelled Orders<span
                                class="badge badge-transparent total_open_complaint"></span></a>
                    </li>

                </ul>

                <hr>

                <div class="tab-content tabs" id="home">

                    <div role="tabpanel" class="tab-pane active" id="Section1">

                        <div class="table-responsive">
                            <table class="table table-striped" style="width: 100% !important;" id="allOrderTable">
                                <thead>
                                    <tr>
                                        <th>Order Id</th>
                                        <th>Username</th>
                                        <th>Total</th>
                                        <th>Status</th>
                                        <th>Payment Type</th>
                                        <th>Date</th>
                                        <th>Action</th>
                                        <th>Start Delivery</th>

                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>


                    <div role="tabpanel" class="tab-pane " id="Section2">
                        <div class="table-responsive">
                            <table class="table table-striped" style="width: 100% !important;" id="ProcessingTable">
                                <thead>
                                    <tr>
                                        <th>Order Id</th>
                                        <th>Username</th>
                                        <th>Total</th>
                                        <th>Status</th>
                                        <th>Payment Type</th>
                                        <th>Date</th>
                                        <th>Action</th>
                                        <th>Start Delivery</th>

                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>

                    <script>
                        $(document).ready(function() {

                            $('#ProcessingTable').dataTable({
                                'processing': true,
                                'serverSide': true,
                                'serverMethod': 'post',
                                "aaSorting": [
                                    [0, "desc"]
                                ],
                                'columnDefs': [{
                                    'targets': [1, 2, 3, 4, 5, 6], // column index (start from 0)
                                    'orderable': false,

                                    /* column index */
                                    // 'orderable': false,
                                    /* true or false */
                                }],
                                'ajax': {
                                    'url': '{{ route('fetchAllProcessingOrder') }}',
                                    'data': function(data) {

                                    }
                                }
                            });

                        });

                    </script>


                    <div role="tabpanel" class="tab-pane " id="Section3">
                        <div class="table-responsive">
                            <table class="table table-striped" style="width: 100% !important;" id="ConfirmedTable">
                                <thead>
                                    <tr>
                                        <th>Order Id</th>
                                        <th>Username</th>
                                        <th>Total</th>
                                        <th>Status</th>
                                        <th>Payment Type</th>
                                        <th>Date</th>
                                        <th>Action</th>

                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>


                    <script>
                        $(document).ready(function() {

                            $('#ConfirmedTable').dataTable({
                                'processing': true,
                                'serverSide': true,
                                'serverMethod': 'post',
                                "aaSorting": [
                                    [0, "desc"]
                                ],
                                'columnDefs': [{
                                    'targets': [1, 2, 3, 4, 5], // column index (start from 0)
                                    'orderable': false,

                                    /* column index */
                                    // 'orderable': false,
                                    /* true or false */
                                }],
                                'ajax': {
                                    'url': '{{ route('fetchAllConfirmedOrder') }}',
                                    'data': function(data) {

                                    }
                                }
                            });

                        });

                    </script>


                    <div role="tabpanel" class="tab-pane " id="Section4">
                        <div class="table-responsive">
                            <table class="table table-striped" style="width: 100% !important;" id="holdTable">
                                <thead>
                                    <tr>
                                        <th>Order Id</th>
                                        <th>Username</th>
                                        <th>Total</th>
                                        <th>Status</th>
                                        <th>Reason</th>
                                        <th>Date</th>
                                        <th>Action</th>
                                        <th>Start Delivery</th>

                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>


                    <script>
                        $(document).ready(function() {

                            $('#holdTable').dataTable({
                                'processing': true,
                                'serverSide': true,
                                'serverMethod': 'post',
                                "aaSorting": [
                                    [0, "desc"]
                                ],
                                'columnDefs': [{
                                    'targets': [1, 2, 3, 4, 5, 6], // column index (start from 0)
                                    'orderable': false,

                                    /* column index */
                                    // 'orderable': false,
                                    /* true or false */
                                }],
                                'ajax': {
                                    'url': '{{ route('fetchAllHoldOrder') }}',
                                    'data': function(data) {

                                    }
                                }
                            });

                        });

                    </script>



                    <div role="tabpanel" class="tab-pane " id="Section5">
                        <div class="table-responsive">
                            <table class="table table-striped" style="width: 100% !important;" id="CompletedTable">
                                <thead>
                                    <tr>
                                        <th>Order Id</th>
                                        <th>Username</th>
                                        <th>Total</th>
                                        <th>Status</th>
                                        <th>Payment Type</th>

                                        <th>Date</th>
                                        <th>Action</th>

                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>



                    <script>
                        $(document).ready(function() {

                            $('#CompletedTable').dataTable({
                                'processing': true,
                                'serverSide': true,
                                'serverMethod': 'post',
                                "aaSorting": [
                                    [0, "desc"]
                                ],
                                'columnDefs': [{
                                    'targets': [1, 2, 3, 4, 5], // column index (start from 0)
                                    'orderable': false,

                                    /* column index */
                                    // 'orderable': false,
                                    /* true or false */
                                }],
                                'ajax': {
                                    'url': '{{ route('fetchAllCompletedOrder') }}',
                                    'data': function(data) {

                                    }
                                }
                            });

                        });

                    </script>





                    <div role="tabpanel" class="tab-pane " id="Section6">
                        <div class="table-responsive">
                            <table class="table table-striped" style="width: 100% !important;" id="CancelledTable">
                                <thead>
                                    <tr>
                                        <th>Order Id</th>
                                        <th>Username</th>
                                        <th>Total</th>
                                        <th>Status</th>
                                        <th>Payment Type</th>
                                        <th>Date</th>
                                        <th>Action</th>

                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>

                    <script>
                        $(document).ready(function() {

                            $('#CancelledTable').dataTable({
                                'processing': true,
                                'serverSide': true,
                                'serverMethod': 'post',
                                "aaSorting": [
                                    [0, "desc"]
                                ],
                                'columnDefs': [{
                                    'targets': [1, 2, 3, 4, 5], // column index (start from 0)
                                    'orderable': false,

                                    /* column index */
                                    // 'orderable': false,
                                    /* true or false */
                                }],
                                'ajax': {
                                    'url': '{{ route('fetchAllCancelledOrder') }}',
                                    'data': function(data) {

                                    }
                                }
                            });

                        });

                    </script>

                </div>
            </div>
        </div>
    </div>



    <script>
        $(document).ready(function() {


            $(".sideBarli").removeClass("activeLi");
            $(".ordersSideA").addClass("activeLi");

            $('#allOrderTable').dataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                "aaSorting": [
                    [0, "desc"]
                ],
                'columnDefs': [{
                    'targets': [1, 2, 3, 4, 5, 6], // column index (start from 0)
                    'orderable': false,

                    /* column index */
                    // 'orderable': false,
                    /* true or false */
                }],
                'ajax': {
                    'url': '{{ route('fetchAllOrder') }}',
                    'data': function(data) {

                    }
                }
            });


            $(document).on("click", ".deleteOrder", function(event) {

                event.preventDefault();



                swal({
                        title: "Are you sure?",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            swal("Your order has been deleted", {
                                icon: "success",
                            });

                            if (user_type == "1") {
                                var element = $(this).parent();

                                var id = $(this).attr("rel");
                                var delete_cat_url = "{{ route('deleteOrder', '') }}" + "/" + id;

                                $.getJSON(delete_cat_url).done(function(data) {
                                    console.log(data);
                                });

                                $('#allOrderTable').DataTable().ajax.reload(null, false);
                                $('#CancelledTable').DataTable().ajax.reload(null, false);
                                $('#CompletedTable').DataTable().ajax.reload(null, false);
                                $('#holdTable').DataTable().ajax.reload(null, false);
                                $('#ConfirmedTable').DataTable().ajax.reload(null, false);
                                $('#ProcessingTable').DataTable().ajax.reload(null, false);

                            } else {
                                iziToast.error({
                                    title: 'Error!',
                                    message: ' you are a tester  ',
                                    position: 'topRight'
                                });
                            }

                        } else {
                            swal("Your order is safe");
                        }
                    });


            });
        });

    </script>

@endsection
