@extends('include.app')

@section('content')

    <div class="text-right mb-3">
        <a class="btn btn-primary" href="" data-toggle="modal" data-target="#addcat" onclick="myFunction()">Add FAQs
        </a>
    </div>


    <div class="modal fade" id="addcat" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog  modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <div class=" ">
                        <h5>Add FAQs</h5>
                    </div>
                    {{-- <h5 class="modal-title" id="exampleModalLongTitle"></h5> --}}
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">



                    <div class="">
                        <form action="" method="post" enctype="multipart/form-data" class="" id="addForm"
                            autocomplete="off">
                            @csrf
                            <div class="form-group">
                                <label>Question</label>
                                <input type="text" name="question" class="form-control" required>
                            </div>

                            <div class="form-group">
                                <label>Answer</label>
                                <textarea name="answer" class="form-control" required></textarea>
                            </div>


                            <div class="form-group text-right">
                                <input class="btn btn-success mr-1" type="submit" id="addcat2" value="Save">
                                <a href="#" class="btn btn-light text-dark" data-dismiss="modal"
                                    aria-label="Close">Close</a>
                            </div>

                        </form>


                    </div>



                </div>

            </div>
        </div>
    </div>






    <div class="card">
        <div class="card-header">
            <h4>FAQs </h4>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped" style="width: 100% !important;" id="faqTable">
                    <thead>
                        <tr class="">
                            <th class="" style="width: 35% !important;">Question</th>
                            <th style="width: 50% !important;">Answer</th>
                            <th style="width: 15% !important;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <div class="modal fade" id="edit_cat_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit FAQs</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="" method="post" enctype="multipart/form-data" id="editFaq" autocomplete="off">

                        @csrf
                        <input type="hidden" class="form-control" id="editcatid" name="id" value="">

                        <div class="form-group">
                            <label for="">Question</label>
                            <input type="text" class="form-control" id="editquestion" name="question" required>
                        </div>

                        <div class="form-group">
                            <label for="">Answer</label>
                            <textarea class="form-control" id="editanswer" name="answer" required>
                            </textarea>
                        </div>



                        <div class="form-group text-right">
                            <input type="submit" class=" btn btn-success" id="editcat2">
                            <a href="#" class="btn btn-light text-dark" data-dismiss="modal" aria-label="Close">Close</a>
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>

    <script>
        function myFunction() {

            $('#addForm')[0].reset();


        }

        var user_type = {{ session('user_type') }};

        $(document).ready(function() {


    
            $(".sideBarli").removeClass("activeLi");
            $(".faqsSideA").addClass("activeLi");

            $('#faqTable').dataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                "aaSorting": [
                    [0, "desc"]
                ],
                'columnDefs': [{
                    'targets': [2], // column index (start from 0)
                    'orderable': false,

                    /* column index */
                    // 'orderable': false,
                    /* true or false */
                }],
                'ajax': {
                    'url': '{{ route('fetchAllFaq') }}',
                    'data': function(data) {

                    }
                }
            });



            $("#addForm").submit(function(event) {
                event.preventDefault();
                $('.loader').show();


                if (user_type == "1") {

                    var formdata = new FormData($("#addForm")[0]);
                    console.log(formdata);


                    $.ajax({
                        url: '{{ route('addfaq') }}',
                        type: 'POST',
                        data: formdata,
                        dataType: "json",
                        contentType: false,
                        cache: false,
                        processData: false,
                        success: function(response) {
                            console.log(response);

                            if (response.status == true) {
                                $('#faqTable').DataTable().ajax.reload(null, false);
                                $('.loader').hide();
                                $('#addcat').modal('hide');
                                $('#addForm')[0].reset();
                            }

                        },
                        error: function(err) {
                            $('.loader').hide();

                            console.log(JSON.stringify(err));


                        }

                    });
                } else {

                    $('.loader').hide();
                    iziToast.error({
                        title: 'Error!',
                        message: ' you are a tester ',
                        position: 'topRight'
                    });
                }

            });

            $("#faqTable").on("click", ".editfaq", function(event) {



                $('#editcatid').val($(this).attr('data-id'));
                var id = $(this).attr("data-id");


                var url2 = "{{ route('getFaqid', '') }}" + "/" + id;

                $.getJSON(url2).done(function(data) {

                    var data2 = data['faqs'];

                    $('#editanswer').val(data2['answer']);
                    $('#editquestion').val(data2['question']);




                });
            });


            $("#editFaq").submit(function(event) {
                event.preventDefault();
                $('.loader').show();


                if (user_type == "1") {

                    var formdata = new FormData($("#editFaq")[0]);
                    console.log(formdata);


                    $.ajax({
                        url: '{{ route('updateFaq') }}',
                        type: 'POST',
                        data: formdata,
                        dataType: "json",
                        contentType: false,
                        cache: false,
                        processData: false,
                        success: function(response) {
                            console.log(response);

                            if (response.status == true) {
                                $('#faqTable').DataTable().ajax.reload(null, false);
                                $('.loader').hide();
                                $('#edit_cat_modal').modal('hide');

                            }

                        },
                        error: function(err) {
                            $('.loader').hide();

                            console.log(JSON.stringify(err));


                        }

                    });
                } else {

                    $('.loader').hide();
                    iziToast.error({
                        title: 'Error!',
                        message: ' you are a tester ',
                        position: 'topRight'
                    });
                }

            });

            $("#faqTable").on("click", ".deletefaq", function(event) {

                event.preventDefault();



                swal({
                        title: "Are you sure?",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            swal("Your FAQs has been deleted", {
                                icon: "success",
                            });

                            if (user_type == "1") {
                                var element = $(this).parent();

                                var cat_id = $(this).attr("rel");
                                var delete_cat_url = "{{ route('deleteFaq', '') }}" + "/" + cat_id;

                                $.getJSON(delete_cat_url).done(function(data) {
                                    console.log(data);
                                });

                                $('#faqTable').DataTable().ajax.reload(null, false);

                            } else {
                                iziToast.error({
                                    title: 'Error!',
                                    message: ' you are a tester ',
                                    position: 'topRight'
                                });
                            }

                        } else {
                            swal("Your FAQs is safe");
                        }
                    });


            });


        });

    </script>
@endsection
