@extends('include.app')

@section('content')

<div class="text-right mb-3">
    <a class="btn btn-primary" href="" data-toggle="modal" data-target="#addDeliveryBoyModal" onclick="myFunction()">Add Delivery Boy
    </a>
</div>

<div class="modal fade" id="addDeliveryBoyModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog ">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="ModalLabel">Add Delivery Boy</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="addDeliveryBoyForm" method="post" enctype="multipart" >
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label >Username</label>
                        <input type="text"  class="form-control " name="username"
                            placeholder="Username"  value="" required>
                    </div>

                    <div class="form-group">
                        <label for="password">Password</label>
                        <input  type="password" class="form-control " name="password" aria-invalid="false" required>
                    </div>

                    <div class="form-group">
                        <label >Full Name</label>
                        <input type="text"  class="form-control " name="fullname"
                            placeholder="Full Name"  value="" required>
                    </div>

                    <div class="form-group upto">
                        <label>Phone Number</label>
                        <div class="input-group mb-2 mr-sm-2">
                            <div class="input-group-prepend">
                                <div class="input-group-text"><i class="fas fa-phone-volume text-dark"></i></div>
                            </div>
                            
                            <input type="number" name="number"  placeholder="Phone Number"
                                class="form-control " required>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Save</button>
                    <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
   
  
</script>

<div class="card">
    <div class="card-header">
        <h4>Delivery Boys </h4>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped" style="width: 100% !important;" id="deliveryBoyTable">
                <thead>
                    <tr>
                        <th>Image</th>
                        <th>Username</th> 
                        <th>Full Name</th>
                        <th>Number</th>
                        <th>Amount To Pay</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="editdbmodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
aria-hidden="true">
<div class="modal-dialog" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="ModalLabel">Edit Details</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">×</span>
            </button>
        </div>
        <form id="editDeliveryBoyForm" method="post" enctype="multipart" novalidate="novalidate">
            @csrf
            <div class="modal-body">
                <div class="form-group">
                    <label >Username</label>
                    <input type="text"  class="form-control username" name="username"
                        placeholder="Username" value="" required>
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <input  type="password" class="form-control password" name="password" aria-invalid="false" required>
                </div>

                <div class="form-group">
                    <label >Full Name</label>
                    <input type="text"  class="form-control fullname" name="fullname"
                        placeholder="Full Name"  value="" required>
                </div>

                <div class="form-group upto">
                    <label >Phone Number</label>
                    <div class="input-group mb-2 mr-sm-2">
                        <div class="input-group-prepend">
                            <div class="input-group-text"><i class="fas fa-phone-volume text-dark"></i></div>
                        </div>
                        <input type="number" name="number" placeholder="Phone Number"
                            class="form-control number" required>
                    </div>
                </div>

            </div>

            <input type="hidden" name='id' class="id">
            <div class="modal-footer">
                <button type="submit" class="btn btn-success">Save</button>
                <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
            </div>
        </form>
    </div>
</div>
</div>

<script>
    function myFunction() {

$('#addDeliveryBoyForm')[0].reset();



}

$(document).ready(function () {

    $(".sideBarli").removeClass("activeLi");
            $(".deliveryBoySideA").addClass("activeLi");


    $('#deliveryBoyTable').dataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                "aaSorting": [
                    [0, "desc"]
                ],
                'columnDefs': [{
                    'targets': [0,2,3,4,5], // column index (start from 0)
                    'orderable': false,

                }],
                'ajax': {
                    'url': '{{ route('fetchAllDbList') }}',
                    'data': function(data) {

                    }
                }
            });

            $("#addDeliveryBoyForm").submit(function(event) {
                event.preventDefault();
                $('.loader').show();


                if (user_type == "1") {

                    var formdata = new FormData($("#addDeliveryBoyForm")[0]);
                    console.log(formdata);


                    $.ajax({
                        url: '{{ route('addDeliveryBoy') }}',
                        type: 'POST',
                        data: formdata,
                        dataType: "json",
                        contentType: false,
                        cache: false,
                        processData: false,
                        success: function(response) {
                            console.log(response);

                            if (response.status == true) {
                                $('#deliveryBoyTable').DataTable().ajax.reload(null, false);
                                $('.loader').hide();
                                $('#addDeliveryBoyModal').modal('hide');
                                $('#addDeliveryBoyForm')[0].reset();

                            }else {
                                $('.loader').hide();
                                iziToast.error({
                                    title: 'Error!',
                                    message: 'Delivery Boy Already Exists.',
                                    position: 'topRight'
                                });
                            }

                        },
                        error: function(err) {
                            $('.loader').hide();

                            console.log(JSON.stringify(err));
                           
                                $('.loader').hide();
                                iziToast.error({
                                    title: 'Error!',
                                    message: 'Envalid Number',
                                    position: 'topRight'
                                });



                        }

                    });
                } else {

                    $('.loader').hide();
                    iziToast.error({
                        title: 'Error!',
                        message: '  you are a tester  ',
                        position: 'topRight'
                    });
                }

            });


            $(document).on("click", ".edititem", function(event) {
                $('#editDeliveryBoyForm')[0].reset();

        

                $('.id').val($(this).attr('rel'));
                var id = $(this).attr("rel");
                var url2 = "{{route('getDbById', '')}}"+"/"+id;

                $.getJSON(url2).done(function(data) {

                    var data2 = data['datas'];
                    
                    $('.number').val(data2['number']);
                    $('.fullname').val(data2['fullname']);
                    $('.username').val(data2['username']);
                    $('.password').val(data2['password']);
                   
                });

                $('#editdbmodal').modal('show');
            });


            $("#editDeliveryBoyForm").submit(function(event) {
                event.preventDefault();
                $('.loader').show();


                if (user_type == "1") {

                    var formdata = new FormData($("#editDeliveryBoyForm")[0]);
                    console.log(formdata);


                    $.ajax({
                        url: '{{ route('editDeliveryBoy') }}',
                        type: 'POST',
                        data: formdata,
                        dataType: "json",
                        contentType: false,
                        cache: false,
                        processData: false,
                        success: function(response) {
                            console.log(response);

                            if (response.status == true) {
                                $('#deliveryBoyTable').DataTable().ajax.reload(null, false);
                                $('.loader').hide();
                                $('#editdbmodal').modal('hide');
                              
                                $('#editDeliveryBoyForm')[0].reset();

                            }else {
                                $('.loader').hide();
                                iziToast.error({
                                    title: 'Error!',
                                    message: 'Delivery Boy Already Exists.',
                                    position: 'topRight'
                                });
                            }

                        },
                        error: function(err) {
                            $('.loader').hide();

                            console.log(JSON.stringify(err));
                           
                                $('.loader').hide();
                                iziToast.error({
                                    title: 'Error!',
                                    message: 'Envalid Number',
                                    position: 'topRight'
                                });



                        }

                    });
                } else {

                    $('.loader').hide();
                    iziToast.error({
                        title: 'Error!',
                        message: ' you are a tester ',
                        position: 'topRight'
                    });
                }

            });


            $("#deliveryBoyTable").on("click",".delete-item",function(event) {

event.preventDefault();



swal({
        title: "Are you sure?",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
    .then((willDelete) => {
        if (willDelete) {
            swal("Your details has been deleted", {
                icon: "success",
            });

            if (user_type == "1") {
                var element = $(this).parent();

                var id = $(this).attr("rel");
                var delete_cat_url = "{{route('deleteDeliveryBoy', '')}}"+"/"+id;
    
                $.getJSON(delete_cat_url).done(function(data) {
                    console.log(data);
                });

                $('#deliveryBoyTable').DataTable().ajax.reload(null, false);
            
            } else {
                iziToast.error({
                    title: 'Error!',
                    message: ' you are a tester  ',
                    position: 'topRight'
                });
            }

        } else {
            swal("Your details is safe");
        }
    });


});

      

});
</script>
    
@endsection