@extends('include.app')

@section('content')
<?php
use Illuminate\Support\Facades\DB;
$settingData = Db::table('shippingcharge')->where('id',1)->first();
    
    $currencies = $settingData->currencies;

?>

    <div class="text-right mb-3">
        <a class="btn btn-primary" href="" data-toggle="modal" data-target="#couponModal" onclick="myFunction()">Add Coupon
        </a>
    </div>

    <div class="modal fade" id="couponModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="ModalLabel">Add Coupon</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form id="addCoupon" method="post" enctype="multipart" novalidate="novalidate">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="coupon_code">Coupon Code</label>
                            <input type="text" id="coupon_code" class="form-control coupon_code" name="coupon_code"
                                placeholder="Coupon code" style="text-transform:uppercase" value="" required>
                        </div>
                        <div class="form-group">
                            <label for="description">Coupon Description</label>
                            <input type="text" id="description" class="form-control description" name="description"
                                placeholder="Coupon Description" value="" required>
                        </div>
                        <div class="form-group">
                            <label for="discount_type">Discount Type</label>
                            <select class="form-control form-control-lg discount_type valid" id="discount_type" name="type"
                                aria-invalid="false" required>
                                <option value="" disabled>Select</option>
                                <option value="1">Flat Discount</option>
                                <option value="2">Upto Discount</option>
                            </select>
                        </div>
                        <div class="form-group flat">
                            <label for="coupon_discount">Discount Amount</label>
                            <div class="input-group mb-2 mr-sm-2">
                                <input type="number" id="coupon_discount" name="discount" placeholder="Discount Amount"
                                    class="form-control coupon_discount" onchange="handleChange(this);" value="" required>
                                <div class="input-group-prepend">
                                    <div class="input-group-text">%</div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group upto">
                            <label for="min_amount">Minimum Order Amount</label>
                            <div class="input-group mb-2 mr-sm-2">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">{{$currencies}}</div>
                                </div>
                                <input type="number" id="min_amount" name="minamount" placeholder="Minimum Order Amount"
                                    class="form-control min_amount" required>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <input type="hidden" name="coupon_id" id="coupon_id" value="">
                        <button type="submit" class="btn btn-success">Save</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div class="card">
        <div class="card-header">
            <h4>Coupons </h4>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped" style="width: 100% !important;" id="coupontable">
                    <thead>
                        <tr>
                            <th>Coupon Code</th>
                            <th>Type</th>
                            <th>Discount</th>
                            <th>Min. Amount</th>
                            <th>Description</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="modal fade" id="edit_unit_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="ModalLabel">Edit Coupon</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form id="editCoupon" method="post" enctype="multipart" novalidate="novalidate">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="coupon_code">Coupon Code</label>
                            <input type="text" id="editcoupon_code" class="form-control coupon_code" name="coupon_code"
                                placeholder="Coupon code" style="text-transform:uppercase" value="" required>
                        </div>
                        <div class="form-group">
                            <label for="description">Coupon Description</label>
                            <input type="text" id="editdescription" class="form-control description" name="description"
                                placeholder="Coupon Description" value="" required>
                        </div>
                        <div class="form-group">
                            <label for="discount_type">Discount Type</label>
                            <select class="form-control form-control-lg discount_type valid" id="editdiscount_type" name="type"
                                aria-invalid="false" required>
                               
                                
                            </select>
                        </div>
                        <div class="form-group flat">
                            <label for="coupon_discount">Discount Amount</label>
                            <div class="input-group mb-2 mr-sm-2">
                                <input type="number" id="editcoupon_discount" name="discount" placeholder="Discount Amount"
                                    class="form-control " onchange="handleChange(this);" value="" required>
                                <div class="input-group-prepend">
                                    <div class="input-group-text">%</div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group upto">
                            <label for="min_amount">Minimum Order Amount</label>
                            <div class="input-group mb-2 mr-sm-2">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">{{$currencies}}</div>
                                </div>
                                <input type="number" id="editmin_amount" name="minamount" placeholder="Minimum Order Amount"
                                    class="form-control editmin_amount" required>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <input type="hidden" name="id" id="editcoupon_id" value="">
                        <button type="submit" class="btn btn-success">Save</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>



    <script>
        function myFunction() {

            $('#addCoupon')[0].reset();



        }

        function handleChange(input) {
            if (input.value < 0) input.value = 0;
            if (input.value > 100) input.value = 100;
        }


        var user_type = {{ session('user_type') }};

        $(document).ready(function() {


            $(".sideBarli").removeClass("activeLi");
        $(".couponsSideA").addClass("activeLi");

            $("#addCoupon").submit(function(event) {
                event.preventDefault();
                $('.loader').show();


                if (user_type == "1") {

                    var formdata = new FormData($("#addCoupon")[0]);
                    console.log(formdata);


                    $.ajax({
                        url: '{{ route('addCoupon') }}',
                        type: 'POST',
                        data: formdata,
                        dataType: "json",
                        contentType: false,
                        cache: false,
                        processData: false,
                        success: function(response) {
                            console.log(response);

                            if (response.status == true) {
                                $('#coupontable').DataTable().ajax.reload(null, false);
                                $('.loader').hide();
                                $('#couponModal').modal('hide');
                                $('#addCoupon')[0].reset();

                            } else {
                                $('.loader').hide();
                                $('#coupon_code').focus();
                                //$('#coupon_code').css('border','1px solid red');
                                iziToast.error({
                                    title: 'Error!',
                                    message: 'Coupon Code Already Exists',
                                    position: 'topRight'
                                });
                            }

                        },
                        error: function(err) {
                            $('.loader').hide();

                            console.log(JSON.stringify(err));


                        }

                    });
                } else {

                    $('.loader').hide();
                    iziToast.error({
                        title: 'Error!',
                        message: '  you are a tester ',
                        position: 'topRight'
                    });
                }

            });


            $('#coupontable').dataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                "aaSorting": [
                    [0, "desc"]
                ],
                'columnDefs': [{
                    'targets': [1, 2], // column index (start from 0)
                    'orderable': false,

                    /* column index */
                    // 'orderable': false,
                    /* true or false */
                }],
                'ajax': {
                    'url': '{{ route('fetchAllCoupon') }}',
                    'data': function(data) {

                    }
                }
            });


            $(document).on("click", ".editcoupan", function(event) {
                $('#editCoupon')[0].reset();

        

                $('#editcoupon_id').val($(this).attr('rel'));
                var id = $(this).attr("rel");
                var url2 = "{{route('getCoupanbyid', '')}}"+"/"+id;

                $.getJSON(url2).done(function(data) {

                    var data2 = data['coupons'];
                    
                    $('#editmin_amount').val(data2['minamount']);
                    $('#editcoupon_discount').val(data2['discount']);
                    $('#editdescription').val(data2['description']);
                    $('#editcoupon_code').val(data2['coupon_code']);

                    var ele;
                    var trueAns = data2['type']
                  

                    var ansSelector = $('#editdiscount_type');
                    ansSelector.empty();
                    ansSelector.append(
                        `<option ${ trueAns == 1 ? "selected" : '' } value="1">Flat Discount</option>`);
                    ansSelector.append(
                        `<option ${ trueAns == 2 ? "selected" : '' } value="2">Upto Discount</option>`
                        );
                   
                });

                $('#edit_unit_modal').modal('show');
            });


            $("#editCoupon").submit(function(event) {
                event.preventDefault();
                $('.loader').show();


                if (user_type == "1") {


                    var formdata = new FormData($("#editCoupon")[0]);
                    console.log(formdata);


                    $.ajax({
                        url: '{{ route('updateCoupon') }}',
                        type: 'POST',
                        data: formdata,
                        dataType: "json",
                        contentType: false,
                        cache: false,
                        processData: false,
                        success: function(response) {
                            console.log(response);

                            if (response.status == true) {
                                $('#coupontable').DataTable().ajax.reload(null, false);
                                $('#editCoupon')[0].reset();
                                $('.loader').hide();
                                $('#edit_unit_modal').modal('hide');

                            } else {
                                $('.loader').hide();
                                iziToast.error({
                                    title: 'Error!',
                                    message: 'Coupon Already Exists',
                                    position: 'topRight'
                                });
                            }

                        },
                        error: function(err) {

                            $('.loader').hide();

                            console.log(JSON.stringify(err));


                        }

                    });


                } else {
                    $('.loader').hide();
                    iziToast.error({
                        title: 'Error!',
                        message: '  you are a tester ',
                        position: 'topRight'
                    });
                }
            });

            $("#coupontable").on("click",".deleteCoupon",function(event) {

                event.preventDefault();



                swal({
                        title: "Are you sure?",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            swal("Your Coupan has Been Deleted", {
                                icon: "success",
                            });

                            if (user_type == "1") {
                                var element = $(this).parent();

                                var id = $(this).attr("rel");
                                var delete_cat_url = "{{route('deleteCoupan', '')}}"+"/"+id;
                    
                                $.getJSON(delete_cat_url).done(function(data) {
                                    console.log(data);
                                });

                                $('#coupontable').DataTable().ajax.reload(null, false);
                            
                            } else {
                                iziToast.error({
                                    title: 'Error!',
                                    message: ' you are a tester  ',
                                    position: 'topRight'
                                });
                            }

                        } else {
                            swal("Your coupan is safe");
                        }
                    });


                });
        });

    </script>

@endsection
